<?php
require_once "../../autoloader.php";
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, OPTIONS, PUT, DELETE");
header("Allow: POST, OPTIONS, PUT, DELETE");
header(
  "Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin"
);
$headers = apache_request_headers();
$response = [];
$controller = new SubscriberModel();

date_default_timezone_set('Africa/Lagos');
$input = @file_get_contents("php://input");
$body = json_decode($input);

if (isset($_GET["transactions"])) {
  $response["status"] = "success";
  $response["transactions"] = $controller->getTransactions();
  echo json_encode($response);
  exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = $body->user_id;
  $amount = $body->amount;
  $action = $body->action;
  $ref = $body->ref;
  $old = $body->old;
$new = $body->new;
  $reason = "";

  $result = $controller->creditDebitUser(
    $email,
    $action,
    $amount,
    $reason,
    $ref,
    $old,
    $new
  );

  if ($result["status"] == "fail") {
    header('HTTP/1.0 400 Invalid Info');
    $response['status'] = "fail";
    $response['msg'] = "The Info is invalid";
    echo json_encode($response);
    exit();
  } else {
    $response = ['status' => 'success'];
    echo json_encode($response);
    exit();
  }
} else {
  $response = ['status' => 'error', 'message' => 'Invalid request method'];
  echo json_encode($response);
}
?>
