<?php
require_once "../../autoloader.php";
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, OPTIONS, PUT, DELETE");
header("Allow: POST, OPTIONS, PUT, DELETE");
header(
  "Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin"
);
$headers = apache_request_headers();
$response = [];
$controller = new SubscriberModel();

date_default_timezone_set('Africa/Lagos');
$input = @file_get_contents("php://input");
$body = json_decode($input);

if (isset($_GET["plans"])) {
  $response["status"] = "success";
  $response["plans"] = $controller->getDataPlans();
  echo json_encode($response);
  exit();
}

if (isset($_GET["network"])) {
  $response["network"] = $controller->getNetwork();
  echo json_encode($response);
  exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $network = $body->datanetwork;
  $dataname = $body->name;
  $datatype = $body->type;
  $planid = $body->planid;
  $duration = $body->day;
  $price = $body->price;
  $buyprice = $body->buyprice;

  $result = $controller->addDataPlan(
    $network,
    $dataname,
    $datatype,
    $planid,
    $duration,
    $price,
    $buyprice
  );

  if ($result["status"] == "fail") {
    header('HTTP/1.0 400 Invalid Info');
    $response['status'] = "fail";
    $response['msg'] = "The Info is invalid";
    echo json_encode($response);
    exit();
  } else {
    $response = ['status' => 'success'];
    echo json_encode($response);
    exit();
  }
} else {
  $response = ['status' => 'error', 'message' => 'Invalid request method'];
  echo json_encode($response);
}
?>
