<?php
require_once "../../autoloader.php";
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, OPTIONS, PUT, DELETE");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$response = [];
$controller = new SubscriberModel();

date_default_timezone_set('Africa/Lagos');
$input = @file_get_contents("php://input");
$body = json_decode($input, true);
if (isset($_GET["users"])) {
     $response["status"] = "success";
     $response["users"] = $controller->getUsers();
     echo json_encode($response);
     exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     $result = $controller->insertUserId($body);
     
     if ($result["status"] == "fail") {
          header('HTTP/1.0 400 Invalid Info');
          $response['status'] = "fail";
          $response['msg'] = "The Info is invalid";
          echo json_encode($response);
          exit();
     }
     $response = ['status' => 'success', 'results' => $results];
     echo json_encode($response);
     exit();
} else {
     $response = ['status' => 'error', 'message' => 'Invalid request method'];
     echo json_encode($response);
}
?>
