<?php
require_once "../../autoloader.php";

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept");

// Set the timezone
date_default_timezone_set('Africa/Lagos');

$response = [];
$controller = new SubscriberModel();

// Read JSON input
$input = file_get_contents("php://input");
$body = json_decode($input, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Validate request type
    if (!isset($body['type'])) {
        echo json_encode(['status' => 'error', 'message' => 'Request type is missing']);
        exit();
    }

    $type = $body['type'];

    if ($type === "verify") {
        // Phone verification request
        if (!isset($body['phone']) || empty($body['phone'])) {
            echo json_encode(['status' => 'error', 'message' => 'Phone number is required']);
            exit();
        }

        $user_phone = $body['phone'];
        $result = $controller->verifyUserExists($user_phone);
file_put_contents('rokik.txt',json_encode($result));
        echo json_encode($result);
        exit();
    
    } elseif ($type === "register") {
    $requiredFields = ["first_name", "last_name", "email", "phone", "password", "passcode"];
    
    foreach ($requiredFields as $field) {
        if (!isset($body[$field]) || empty($body[$field])) {
            echo json_encode(['status' => 'error', 'message' => "Missing required field: $field"]);
            exit();
        }
    }

    $first_name = trim($body['first_name']);
    $last_name = trim($body['last_name']);
    $email = trim($body['email']);
    $phone = trim($body['phone']); // Ensure phone is included
    $password = trim($body['password']); // Remove password_hash()
    $passcode = trim($body['passcode']);
    $referral = trim($body['referral']);
    $sent_code = trim($body['sent_code']);
    $confirmation_code = trim($body['confirmation_code']);

    if ($sent_code !== $confirmation_code) {
        echo json_encode(['status' => 'error', 'message' => 'Confirmation code does not match']);
        exit();
    }

    $registerResult = $controller->registerUser($first_name, $last_name, $email, $phone, $password, $passcode, $referral);

    echo json_encode(['status' => $registerResult->status, 'message' => $registerResult->msg]);
    exit();
} elseif ($type === "login") {
    $requiredFields = ["phone", "password"];
    
    foreach ($requiredFields as $field) {
        if (!isset($body[$field]) || empty($body[$field])) {
            echo json_encode(['status' => 'error', 'message' => "Missing required field: $field"]);
            exit();
        }
    }

   
    $phone = trim($body['phone']); // Ensure phone is included
    $password = trim($body['password']); // Remove password_hash()
    

   
$registerResult = $controller->loginUser($phone, $password);
//file_put_contents('rokik.txt',$registerResult["wallet"]);
if (!is_object($registerResult)) {
    echo json_encode(['status' => 'error', 'message' => 'Unexpected response from login']);
    exit;
}

  
$response = [
    "status" => $registerResult->status ?? 'failed',
    "message"=> $registerResult->msg,
    "Id" => $registerResult->Id ?? '',
    "name" => trim(($registerResult->name ?? '') . " " . ($registerResult->sLname ?? '')),
    "phone" => $registerResult->phone ?? '',
    "email" => $registerResult->email ?? '',
    "fname" => $registerResult->name ?? '',
    "lname" => $registerResult->lname ?? '',
    "pin" => $registerResult->pin ?? '',
    "date" => $registerResult->date ?? '',
    "image" => $registerResult->image ?? '',
    "address" => $registerResult->address ?? '',
    "account_number" => $registerResult->account_number ?? '',
    "account_name" => $registerResult->sFname ?? '',
    "age" => $registerResult->age ?? '',
    "sex" => $registerResult->sex ?? '',
    "user_type" => $registerResult->user_type ?? '',
    "refwallet" => $registerResult->refwallet ?? '',
    "wallet" => $registerResult->wallet ?? '',
    "vercode" => $registerResult->vercode ?? '',
    "moniepoint" => $registerResult->moniepoint ?? '',
    "payvessel" => $registerResult->payvessel ?? '',
    "wema" => $registerResult->wema ?? '',
    "charges" => "1.7%",
    "username" => $registerResult->username ?? '',
    "isbank_verify" => $registerResult->isbank_verify ?? '',
    "apikey" => $registerResult->apikey ?? '',
    "notif" => "You are welcome, we are your one-stop platform for all
                bills payment, airtime, data plans, and cable TV subscription.
                All our services are available to you at a discount rate.
                Our customer support team is available to you 24/7.",
    "vtuaccount" => "WAPAY-" . strtoupper(substr($registerResult->fname ?? 'XXX', 0, 3)), 
    "pin_set" => isset($registerResult->pin) && $registerResult->pin >= 3 ? "yes" : "no"
];

echo json_encode($response);
    exit();
}elseif ($type === "retrieve") {
    $requiredFields = ["phone"];
    
    foreach ($requiredFields as $field) {
        if (!isset($body[$field]) || empty($body[$field])) {
            echo json_encode(['status' => 'error', 'message' => "Missing required field: $field"]);
            exit();
        }
    }

   
    $phone = trim($body['phone']); // Ensure phone is included
   
    

   
$registerResult = $controller->retrieveUser($phone);

if (!is_object($registerResult)) {
    echo json_encode(['status' => 'error', 'message' => 'Unexpected response from login']);
    exit;
}

  
$response = [
    "status" => $registerResult->status ?? 'failed',
    "message"=> $registerResult->msg,
    "Id" => $registerResult->Id ?? '',
    "name" => trim(($registerResult->name ?? '') . " " . ($registerResult->sLname ?? '')),
    "phone" => $registerResult->phone ?? '',
    "email" => $registerResult->email ?? '',
    "fname" => $registerResult->name ?? '',
    "lname" => $registerResult->lname ?? '',
    "pin" => $registerResult->pin ?? '',
    "date" => $registerResult->date ?? '',
    "image" => $registerResult->image ?? '',
    "address" => $registerResult->address ?? '',
    "account_number" => $registerResult->account_number ?? '',
    "account_name" => $registerResult->sFname ?? '',
    "age" => $registerResult->age ?? '',
    "sex" => $registerResult->sex ?? '',
    "user_type" => $registerResult->user_type ?? '',
    "refwallet" => $registerResult->refwallet ?? '',
    "wallet" => $registerResult->wallet ?? '',
    "vercode" => $registerResult->vercode ?? '',
    "moniepoint" => $registerResult->moniepoint ?? '',
    "payvessel" => $registerResult->payvessel ?? '',
    "wema" => $registerResult->wema ?? '',
    "charges" => "1.7%",
    "username" => $registerResult->username ?? '',
    "isbank_verify" => $registerResult->isbank_verify ?? '',
    "apikey" => $registerResult->apikey ?? '',
    "notif" => "You are welcome, we are your one-stop platform for all
                bills payment, airtime, data plans, and cable TV subscription.
                All our services are available to you at a discount rate.
                Our customer support team is available to you 24/7.",
    "vtuaccount" => "WAPAY-" . strtoupper(substr($registerResult->fname ?? 'XXX', 0, 3)), 
    "pin_set" => isset($registerResult->pin) && $registerResult->pin >= 3 ? "yes" : "no"
];

echo json_encode($response);
    exit();
}
 else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid request type']);
        exit();
    }
    
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit();
}
?>
